﻿using System;
using System.IO;

namespace AsyncIo
{
    class Program
    {
        static void Main(string[] args)
        {
            string path = "mytestfile.txt";

            // Listing 11-48. Nie prosimy o działanie asynchroniczne.
            // Tworzymy plik testowy.
            using (var file = File.Create(path, 4096, FileOptions.None))
            {
                // Kilka bajtów do zapisania
                byte[] myBytes = new byte[] { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 };
                IAsyncResult asyncResult = file.BeginWrite(
                    myBytes,
                    0,
                    myBytes.Length,
                    // Funkcja zwrotna w formie anonimowej delegacji
                    delegate(IAsyncResult result)
                    {
                        // Metodę EndWrite() *trzeba* wywołać dokładnie raz...
                        file.EndWrite(result);
                        // ...a potem można już robić, co się nam podoba.
                        Console.WriteLine(
                        "Wywołanie zwrotne w wątku {0}. po zakończeniu operacji.",
                        System.Threading.Thread.CurrentThread.ManagedThreadId);
                    },
                    null);

                // Podczas czekania można by robić coś innego...
                Console.WriteLine(
                    "Oczekiwanie na wątek {0}...",
                    System.Threading.Thread.CurrentThread.ManagedThreadId);
                // Oczekiwanie na wątek główny
                asyncResult.AsyncWaitHandle.WaitOne();
                Console.WriteLine(
                    "Zakończono {0} w wątku {1}...",
                    asyncResult.CompletedSynchronously ?
                        "synchronicznie" : "asynchronicznie",
                    System.Threading.Thread.CurrentThread.ManagedThreadId);
                Console.ReadKey();
                return;
            }
        }
    }
}
